;+
; NAME:
;      LOADCT_PLOT
;
; PURPOSE:
;      Load a simple color table with 8 colors, useful for plots
;      There are 8 colors: 0 is black, 7 is white, and between: red,
;      green, blue, ...
;
; CATEGORY:
;     plots
;
; CALLING SEQUENCE:
;     loadct_plot
; 
; INPUTS:
;     none
;	
; KEYWORD PARAMETERS:
;     /REVERSE: color = 0 is white and color=7 is black
;
; OUTPUTS:
;     none
;
; PROCEDURE:
;     TVLCT
;
; EXAMPLE:
;     loadct_plot
;
; MODIFICATION HISTORY:
;     19-Jun-98 Written, H. Dole, IAS
;-

PRO loadct_plot, reverse=reverse

; COLOR=0 : BLACK
;----------------
r = BYTARR(8)
g = r
b = r

; COLOR=1 : RED 
;--------------
r(1) = 255

; COLOR=2 : GREEN
;----------------
g(2) = 255

; COLOR=3 : BLUE 
;---------------
b(3) = 255

; COLOR=4 : 
;--------
r(4) = 255
g(4) = 255

; COLOR=5 : 
;--------
r(5) = 255
b(5) = 255

; COLOR=6 : 
;--------
g(6) = 255
b(6) = 255

; COLOR=7 : WHITE 
;----------------
r(7) = 255
g(7) = 255
b(7) = 255

; REVERSE CASE
;-------------
IF KEYWORD_SET(reverse) THEN BEGIN
    r(0) = r(7)
    g(0) = g(7)
    b(0) = b(7)
    r(7) = 0
    g(7) = 0
    b(7) = 0
ENDIF

TVLCT, r, g, b

END
